#pragma once

#include "comdef.h"
#include "Error.h"
#include "SdkString.h"

#define IMAGE_SIZE		0x10
#define WM_TRAY_NOTIFY	WM_APP + 1000

typedef struct _READER_INFO
{
	SdkString	strReader;
	SdkString	strFirmware;
	SdkString	strReaderType;
	UINT		nPort;
}READER_INFO, *PREADER_INFO;

typedef union _DATA_STRUCT
{
	struct 
	{
		SHORT	shMaxAttenuation;
		SHORT	shAttenuation;
	}stAttenuation;

	struct 
	{
		SHORT	shMaxSensitivity;
		SHORT	shMinSensitivity;
		SHORT	shSensitivity;
	}stSensitivity;

	struct 
	{
		BYTE	bNrFreq;
		ULONG	lFreq[0x10];	// max nr freq allow = 16 !!!
	}stFrequency;

	struct
	{
		BYTE bTagLength;
		BYTE bTagId;
		BYTE bCardIdLength;
		BYTE pCardId[0x20];
	}stTagInfo;

	struct 
	{
		BYTE nLength;
		BYTE pCardId[0x20];
	}stCardInfo;

	struct 
	{
		BYTE	bCardIdLen;
		BYTE	pCardId[0x20];
		BYTE	pPass[0x04];
		BYTE	bBank;
		ULONG	ulStartAddress;
	}stReadWriteInfo;

	struct 
	{
		BYTE	bCardIdLen;
		BYTE	pCardId[0x20];
		BYTE	pPass[0x04];
	}stKillTagInfo;

	struct 
	{
		BYTE	bCardIdLen;
		BYTE	pCardId[0x20];
		BYTE	pPass[0x04];
		BYTE	bBank;
		BYTE	bLockType;
	}stLockInfo;
}DATA_STRUCT;


